#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai


__license__   = 'GPL v3'
__copyright__ = '2025, Digital Assassins'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

# The class that all interface action plugins must inherit from
from calibre.gui2.actions import InterfaceAction
from PyQt5.QtCore import QTimer

from operator import attrgetter
from calibre.ebooks.metadata.sources.prefs import msprefs        
from calibre.customize.ui import all_metadata_plugins, default_disabled_plugins, disable_plugin, enable_plugin, is_disabled
from calibre.gui2 import error_dialog

class DownloadMetadata(InterfaceAction):

    name = 'Download Metadata'
    action_spec = (name, None,
            'Download Metadata using the Built in Metadata Plugins', None)
    action_type = 'current'

    def genesis(self):
        base_plugin_object = self.interface_action_base_plugin
        self.edit_metadata = self.gui.iactions['Edit Metadata']
        self.icon = get_icons('images/download-metadata.png', 'Download Metadata')
        self.qaction.setIcon(self.icon)
        self.qaction.triggered.connect(self.start_metadata_action)
    
    def get_selected_books_in_main_gui(self):
        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0:
            return error_dialog(self.gui, _('Cannot download metadata'),
                        _('No books selected'), show=True)
        db = self.gui.library_view.model().db
        ids = [db.id(row.row()) for row in rows]
        return ids
        
        
    def start_metadata_action(self):
        # get the ids
        ids = self.get_selected_books_in_main_gui()
        self.start_download(ids)
        return
    
    def start_download(self, ids, ensure_fields=None):        
        #self.edit_metadata.download_metadata(ids)
        from calibre.gui2.metadata.bulk_download import Job, download
        from calibre.ptempfile import PersistentTemporaryDirectory, PersistentTemporaryFile
        from calibre.utils.localization import ngettext
        from calibre.gui2 import Dispatcher
        
        tf = PersistentTemporaryFile('_metadata_bulk.log')
        tf.close()
        
        job = Job('metadata bulk download',
            ngettext(
                'Download metadata for one book',
                'Download metadata for {} books', len(ids)).format(len(ids)),
            download, (ids, tf.name, self.gui.current_db, True, False,
                ensure_fields), {}, Dispatcher(self.metadata_downloaded) )
        job.metadata_and_covers = (True, False)
        job.download_debug_log = tf.name
        self.gui.job_manager.run_threaded_job(job)
        self.gui.status_bar.show_message(_('Metadata download started'), 3000)
    
    def metadata_downloaded(self, job):
        self.edit_metadata.metadata_downloaded(job)
    
    def show_dialog(self):
        return

    def apply_settings(self):
        return