#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai


__license__   = 'GPL v3'
__copyright__ = '2025, Digital Assassins'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

# The class that all interface action plugins must inherit from
from calibre.gui2.actions import InterfaceAction
from calibre_plugins.ai_custom_tag_extractor.main import MainDialog
from calibre_plugins.ai_custom_tag_extractor.review_ui import ReviewDialog
from calibre_plugins.ai_custom_tag_extractor.about_ui import AboutDialog
from calibre_plugins.ai_custom_tag_extractor.job_log_ui import JobLogDialog


class InterfacePlugin(InterfaceAction):

    name = 'AI Custom Tag Extractor'

    # Declare the main action associated with this plugin
    # The keyboard shortcut can be None if you don't want to use a keyboard
    # shortcut. Remember that currently calibre has no central management for
    # keyboard shortcuts, so try to use an unusual/unused shortcut.
    action_spec = ('AI Extractor', None,
            'Extract custom data from your books using the power of AI.', 'Ctrl+Shift+D')

    def genesis(self):
        # This method is called once per plugin, do initial setup here

        # Set the icon for this interface action
        # The get_icons function is a builtin function defined for all your
        # plugin code. It loads icons from the plugin zip file. It returns
        # QIcon objects, if you want the actual data, use the analogous
        # get_resources builtin function.
        #
        # Note that if you are loading more than one icon, for performance, you
        # should pass a list of names to get_icons. In this case, get_icons
        # will return a dictionary mapping names to QIcons. Names that
        # are not found in the zip file will result in null QIcons.
        icon = get_icons('images/icon.png', 'AI Custom Tag Extractor')

        # The qaction is automatically created from the action_spec defined
        # above
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.show_dialog)
    
    def show_job_log_dialog(self, *args):
        jld = JobLogDialog(self.gui, self.qaction.icon(), *args)
        jld.show()
        
    def show_review_dialog(self, *args):
        rd = ReviewDialog(self.gui, self.qaction.icon(), self.show_job_log_dialog, *args)
        rd.show()
        
    def show_about_dialog(self, *args):
        ad = AboutDialog(self.gui, self.qaction.icon(), *args)
        ad.show()
        
    def show_dialog(self):
        # The base plugin object defined in __init__.py
        base_plugin_object = self.interface_action_base_plugin
        # Show the config dialog
        # The config dialog can also be shown from within
        # Preferences->Plugins, which is why the do_user_config
        # method is defined on the base plugin class
        do_user_config = base_plugin_object.do_user_config
        show_review_dialog = self.show_review_dialog
        show_about_dialog = self.show_about_dialog

        # self.gui is the main calibre GUI. It acts as the gateway to access
        # all the elements of the calibre user interface, it should also be the
        # parent of the dialog
        d = MainDialog(self.gui, self.qaction.icon(), do_user_config, show_review_dialog, show_about_dialog)
        d.show()

    def apply_settings(self):
        from calibre_plugins.ai_custom_tag_extractor.config import plugin_prefs
        # In an actual non trivial plugin, you would probably need to
        # do something based on the settings in prefs
        print(plugin_prefs)
