#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai


__license__   = 'GPL v3'
__copyright__ = '2025, Digital Assassins'
__docformat__ = 'restructuredtext en'

# The class that all Interface Action plugin wrappers must inherit from
from calibre.customize import InterfaceActionBase

import sys
import os
lib_dir = os.path.join(os.path.dirname(__file__), 'lib')
if lib_dir not in sys.path:
    sys.path.insert(0, lib_dir)

class DownloadAIMetaDataButton(InterfaceActionBase):
    name                = 'Download AI Metadata Button'
    description         = 'Adds a Download Metadata Button to the Menu for the AI Metadata Plugin'
    supported_platforms = ['windows', 'linux']
    author              = 'Digital Assassins'
    version             = (1, 0, 0)
    minimum_calibre_version = (0, 8, 40)
    actual_plugin       = 'calibre_plugins.download_ai_metadata_menu_item.ui:DownloadAIMetadata'

    def is_customizable(self):
        return False

    def config_widget(self):
        return

    def save_settings(self, config_widget):
        return
