# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'dialog-window.ui'
#
# Created by: PyQt5 UI code generator 5.15.9
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


try:
    from qt.core import Qt, QDialog, QLabel, QMessageBox, QPushButton, QVBoxLayout, QProgressBar, QWidget, QComboBox, QHBoxLayout, QPlainTextEdit, QSize, QSizePolicy, QApplication
except ImportError:
    from PyQt5.Qt import Qt, QDialog, QLabel, QMessageBox, QPushButton, QVBoxLayout, QProgressBar, QWidget, QComboBox, QHBoxLayout, QPlainTextEdit, QSize, QSizePolicy, QApplication

from PyQt5 import QtCore, QtGui, QtWidgets

from calibre.ebooks.metadata.book.base import Metadata

class ReviewDialog(QDialog):
    
    def __init__(self, gui, icon, show_job_log_dialog, parentdlg, *args):
        
        QDialog.__init__(self, gui)
        self.gui = gui
        self.parentdlg = parentdlg
        self.db = gui.current_db
        self.show_job_log_dialog = show_job_log_dialog
        # get the payload from the main window
        self.mguipl = args[0]
        print(self.mguipl)
        self.column_list_count = self.mguipl['vc_count']
        self.combo_display_0 = self.mguipl['combo_0_selected']
        self.combo_display_1 = self.mguipl['combo_1_selected']
        self.combo_display_2 = self.mguipl['combo_2_selected']
        self.combo_display_3 = self.mguipl['combo_3_selected']
        self.combo_label_0 = self.mguipl['combo_0_label']
        self.combo_label_1 = self.mguipl['combo_1_label']
        self.combo_label_2 = self.mguipl['combo_2_label']
        self.combo_label_3 = self.mguipl['combo_3_label']
        self.AI_ANSWERS = args[1]
        print(self.AI_ANSWERS)
        
        ############## LOAD GUI ICONS FOR THIS WINDOW ########################
        icons = get_icons(['images/accept_icon.png','images/decline_icon.png','images/trash_icon.png','images/system_log_icon.png', 'images/progress_info.png','images/stop.png','images/info_icon.png'], 'AI Custom Tag Extractor')
            
        ########################################################################################
        ########################################################################################
        ########################################################################################
        ########################################################################################
        ########################################################################################
        
        self.setObjectName("Dialog")
        self.setWindowIcon(icon)
        self.setWindowModality(QtCore.Qt.NonModal)
        self.resize(800, 648)
        self.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
        self.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.setStyleSheet('QDialog#Dialog{background-image:url(:/images/background_small_faded.png); background-repeat: no-repeat; background-position: bottom left;}')
        self.setSizeGripEnabled(True)
        self.setModal(False)
        
        self.mainVerticalLayout = QtWidgets.QVBoxLayout(self)
        self.mainVerticalLayout.setObjectName("mainVerticalLayout")
        self.topInfoBarLayout = QtWidgets.QHBoxLayout()
        self.topInfoBarLayout.setObjectName("topInfoBarLayout")
        self.topInfoBarHorizontalLayout = QtWidgets.QHBoxLayout()
        self.topInfoBarHorizontalLayout.setObjectName("topInfoBarHorizontalLayout")
        self.resultDisplayText = QtWidgets.QLabel(self)
        self.resultDisplayText.setMaximumSize(QtCore.QSize(60, 30))
        self.resultDisplayText.setAutoFillBackground(False)
        self.resultDisplayText.setStyleSheet("font-size:10pt; font-weight:600;")
        self.resultDisplayText.setScaledContents(False)
        self.resultDisplayText.setWordWrap(False)
        self.resultDisplayText.setOpenExternalLinks(False)
        self.resultDisplayText.setObjectName("resultDisplayText")
        self.topInfoBarHorizontalLayout.addWidget(self.resultDisplayText)
        self.bookNameText = QtWidgets.QLabel(self)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Preferred, QtWidgets.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.bookNameText.sizePolicy().hasHeightForWidth())
        self.bookNameText.setSizePolicy(sizePolicy)
        self.bookNameText.setMinimumSize(QtCore.QSize(400, 0))
        self.bookNameText.setMaximumSize(QtCore.QSize(16777215, 30))
        self.bookNameText.setStyleSheet("font-size:10pt;")
        self.bookNameText.setWordWrap(False)
        self.bookNameText.setObjectName("bookNameText")
        self.topInfoBarHorizontalLayout.addWidget(self.bookNameText)
        self.topInfoBarLayout.addLayout(self.topInfoBarHorizontalLayout)
        spacerItem = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.MinimumExpanding, QtWidgets.QSizePolicy.Minimum)
        self.topInfoBarLayout.addItem(spacerItem)
        
        self.currentPositionHorizontalLayout = QtWidgets.QHBoxLayout()
        self.currentPositionHorizontalLayout.setObjectName("currentPositionHorizontalLayout")
        self.noCurrentText = QtWidgets.QLabel(self)
        self.noCurrentText.setMaximumSize(QtCore.QSize(16777215, 16777215))
        self.noCurrentText.setStyleSheet("font:bold;")
        self.noCurrentText.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.noCurrentText.setObjectName("noCurrentText")
        self.currentPositionHorizontalLayout.addWidget(self.noCurrentText)
        self.outOfLabel = QtWidgets.QLabel(self)
        self.outOfLabel.setMaximumSize(QtCore.QSize(20, 30))
        self.outOfLabel.setStyleSheet("font:bold;")
        self.outOfLabel.setAlignment(QtCore.Qt.AlignCenter)
        self.outOfLabel.setObjectName("outOfLabel")
        self.currentPositionHorizontalLayout.addWidget(self.outOfLabel)
        self.noOutOfText = QtWidgets.QLabel(self)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Preferred, QtWidgets.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.noOutOfText.sizePolicy().hasHeightForWidth())
        self.noOutOfText.setSizePolicy(sizePolicy)
        self.noOutOfText.setMaximumSize(QtCore.QSize(16777215, 16777215))
        self.noOutOfText.setStyleSheet("font:bold;")
        self.noOutOfText.setObjectName("noOutOfText")
        self.currentPositionHorizontalLayout.addWidget(self.noOutOfText)
        self.topInfoBarLayout.addLayout(self.currentPositionHorizontalLayout)
        self.mainVerticalLayout.addLayout(self.topInfoBarLayout)
        self.topHr = QtWidgets.QFrame(self)
        self.topHr.setFrameShape(QtWidgets.QFrame.HLine)
        self.topHr.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.topHr.setObjectName("topHr")
        self.mainVerticalLayout.addWidget(self.topHr)
        
        
        
        self.columnWidget_0 = QtWidgets.QWidget(self)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Preferred, QtWidgets.QSizePolicy.Expanding)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.columnWidget_0.sizePolicy().hasHeightForWidth())
        self.columnWidget_0.setSizePolicy(sizePolicy)
        self.columnWidget_0.setObjectName("columnWidget_0")
        self.columnWidgetVerticalLayout_0 = QtWidgets.QVBoxLayout(self.columnWidget_0)
        self.columnWidgetVerticalLayout_0.setContentsMargins(1, 1, 1, 1)
        self.columnWidgetVerticalLayout_0.setObjectName("columnWidgetVerticalLayout_0")        
        self.columnInternalVerticalLayout_0 = QtWidgets.QVBoxLayout()
        self.columnInternalVerticalLayout_0.setSpacing(7)
        self.columnInternalVerticalLayout_0.setObjectName("columnInternalVerticalLayout_0")
        self.tagHeaderLayout_0 = QtWidgets.QHBoxLayout()
        self.tagHeaderLayout_0.setSizeConstraint(QtWidgets.QLayout.SetMinimumSize)
        self.tagHeaderLayout_0.setObjectName("tagHeaderLayout_0")
        self.columnLabel_0 = QtWidgets.QLabel(self.combo_display_0)
        self.columnLabel_0.setObjectName("columnLabel_0")
        self.tagHeaderLayout_0.addWidget(self.columnLabel_0)
        spacerItem1 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.tagHeaderLayout_0.addItem(spacerItem1)        
        self.columnInternalHorizontalLayout_0 = QtWidgets.QHBoxLayout()
        self.columnInternalHorizontalLayout_0.setObjectName("columnInternalHorizontalLayout_0")
        self.columnRejectBtn_0 = QtWidgets.QPushButton(self.columnWidget_0)
        self.columnRejectBtn_0.setMaximumSize(QtCore.QSize(30, 30))
        self.columnRejectBtn_0.setIcon(icons['images/trash_icon.png'])
        self.columnRejectBtn_0.setObjectName("columnRejectBtn_0")
        self.columnRejectBtn_0.clicked.connect(lambda:self.trash_item(0))
        self.columnInternalHorizontalLayout_0.addWidget(self.columnRejectBtn_0)
        self.tagHeaderLayout_0.addLayout(self.columnInternalHorizontalLayout_0)
        self.columnInternalVerticalLayout_0.addLayout(self.tagHeaderLayout_0)
        self.columnTextEdit_0 = QtWidgets.QTextEdit(self.columnWidget_0)
        self.columnTextEdit_0.setStyleSheet("border: 1px solid grey; border-radius: 5px; background-color: palette(base);")
        self.columnTextEdit_0.setAcceptRichText(True)
        self.columnTextEdit_0.setTextInteractionFlags(QtCore.Qt.LinksAccessibleByMouse|QtCore.Qt.TextSelectableByKeyboard|QtCore.Qt.TextSelectableByMouse)
        self.columnTextEdit_0.setObjectName("columnTextEdit_0")
        self.columnInternalVerticalLayout_0.addWidget(self.columnTextEdit_0)
        self.columnWidgetVerticalLayout_0.addLayout(self.columnInternalVerticalLayout_0)
        self.mainVerticalLayout.addWidget(self.columnWidget_0)
        self.columnWidget_0.raise_()


        if self.column_list_count > 0:
            self.columnWidget_1 = QtWidgets.QWidget(self)
            self.columnWidget_1.setObjectName("columnWidget_1")
            self.columnWidgetVerticalLayout_1 = QtWidgets.QVBoxLayout(self.columnWidget_1)
            self.columnWidgetVerticalLayout_1.setContentsMargins(0, 0, 0, 0)
            self.columnWidgetVerticalLayout_1.setObjectName("columnWidgetVerticalLayout_1")        
            self.columnInternalVerticalLayout_1 = QtWidgets.QVBoxLayout()
            self.columnInternalVerticalLayout_1.setSpacing(7)
            self.columnInternalVerticalLayout_1.setObjectName("columnInternalVerticalLayout_1")
            self.tagHeaderLayout_1 = QtWidgets.QHBoxLayout()
            self.tagHeaderLayout_1.setSizeConstraint(QtWidgets.QLayout.SetMinimumSize)
            self.tagHeaderLayout_1.setObjectName("tagHeaderLayout_1")
            self.columnLabel_1 = QtWidgets.QLabel(self.combo_display_1)
            self.columnLabel_1.setObjectName("columnLabel_1")
            self.tagHeaderLayout_1.addWidget(self.columnLabel_1)
            spacerItem2 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
            self.tagHeaderLayout_1.addItem(spacerItem2)
            self.columnInnerHorizontalLayout_1 = QtWidgets.QHBoxLayout()
            self.columnInnerHorizontalLayout_1.setObjectName("columnInnerHorizontalLayout_1")
            self.columnRejectBtn_1 = QtWidgets.QPushButton(self.columnWidget_1)
            self.columnRejectBtn_1.setMaximumSize(QtCore.QSize(30, 30))
            self.columnRejectBtn_1.setIcon(icons['images/trash_icon.png'])
            self.columnRejectBtn_1.setObjectName("columnRejectBtn_1")
            self.columnRejectBtn_1.clicked.connect(lambda:self.trash_item(1))
            self.columnInnerHorizontalLayout_1.addWidget(self.columnRejectBtn_1)
            self.tagHeaderLayout_1.addLayout(self.columnInnerHorizontalLayout_1)
            self.columnInternalVerticalLayout_1.addLayout(self.tagHeaderLayout_1)
            self.columnTextEdit_1 = QtWidgets.QTextEdit(self.columnWidget_1)
            self.columnTextEdit_1.setStyleSheet("border: 1px solid grey; border-radius: 5px; background-color: palette(base);")
            self.columnTextEdit_1.setTextInteractionFlags(QtCore.Qt.LinksAccessibleByMouse|QtCore.Qt.TextSelectableByKeyboard|QtCore.Qt.TextSelectableByMouse)
            self.columnTextEdit_1.setObjectName("columnTextEdit_1")
            self.columnInternalVerticalLayout_1.addWidget(self.columnTextEdit_1)
            self.columnWidgetVerticalLayout_1.addLayout(self.columnInternalVerticalLayout_1)
            self.mainVerticalLayout.addWidget(self.columnWidget_1)
            self.columnWidget_1.raise_()

            if self.column_list_count > 1:
                self.columnWidget_2 = QtWidgets.QWidget(self)
                self.columnWidget_2.setObjectName("columnWidget_2")
                self.columnWidgetVerticalLayout_2 = QtWidgets.QVBoxLayout(self.columnWidget_2)
                self.columnWidgetVerticalLayout_2.setContentsMargins(0, 0, 0, 0)
                self.columnWidgetVerticalLayout_2.setObjectName("columnWidgetVerticalLayout_2")
                self.columnInternalVerticalLayout_2 = QtWidgets.QVBoxLayout()
                self.columnInternalVerticalLayout_2.setSpacing(7)
                self.columnInternalVerticalLayout_2.setObjectName("columnInternalVerticalLayout_2")
                self.tagHeaderLayout_2 = QtWidgets.QHBoxLayout()
                self.tagHeaderLayout_2.setSizeConstraint(QtWidgets.QLayout.SetMinimumSize)
                self.tagHeaderLayout_2.setObjectName("tagHeaderLayout_2")
                self.columnLabel_2 = QtWidgets.QLabel(self.combo_display_2)
                self.columnLabel_2.setObjectName("columnLabel_2")
                self.tagHeaderLayout_2.addWidget(self.columnLabel_2)
                spacerItem3 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
                self.tagHeaderLayout_2.addItem(spacerItem3)
                self.columnInternalHorizontalLayout_2 = QtWidgets.QHBoxLayout()
                self.columnInternalHorizontalLayout_2.setObjectName("columnInternalHorizontalLayout_2")
                self.columnRejectBtn_2 = QtWidgets.QPushButton(self.columnWidget_2)
                self.columnRejectBtn_2.setMaximumSize(QtCore.QSize(30, 30))
                self.columnRejectBtn_2.setIcon(icons['images/trash_icon.png'])
                self.columnRejectBtn_2.setObjectName("columnRejectBtn_2")
                self.columnRejectBtn_2.clicked.connect(lambda:self.trash_item(2))
                self.columnInternalHorizontalLayout_2.addWidget(self.columnRejectBtn_2)
                self.tagHeaderLayout_2.addLayout(self.columnInternalHorizontalLayout_2)
                self.columnInternalVerticalLayout_2.addLayout(self.tagHeaderLayout_2)
                self.columnTextEdit_2 = QtWidgets.QTextEdit(self.columnWidget_2)
                self.columnTextEdit_2.setStyleSheet("border: 1px solid grey; border-radius: 5px; background-color: palette(base);")
                self.columnTextEdit_2.setTextInteractionFlags(QtCore.Qt.LinksAccessibleByMouse|QtCore.Qt.TextSelectableByKeyboard|QtCore.Qt.TextSelectableByMouse)
                self.columnTextEdit_2.setObjectName("columnTextEdit_2")
                self.columnInternalVerticalLayout_2.addWidget(self.columnTextEdit_2)
                self.columnWidgetVerticalLayout_2.addLayout(self.columnInternalVerticalLayout_2)
                self.mainVerticalLayout.addWidget(self.columnWidget_2)
                self.columnWidget_2.raise_()
                
                if self.column_list_count > 2:
                    self.columnWidget_3 = QtWidgets.QWidget(self)
                    self.columnWidget_3.setObjectName("columnWidget_3")
                    self.columnWidgetVerticalLayout_3 = QtWidgets.QVBoxLayout(self.columnWidget_3)
                    self.columnWidgetVerticalLayout_3.setContentsMargins(0, 0, 0, 0)
                    self.columnWidgetVerticalLayout_3.setSpacing(0)
                    self.columnWidgetVerticalLayout_3.setObjectName("columnWidgetVerticalLayout_3")
                    self.columnInternalVerticalLayout_3 = QtWidgets.QVBoxLayout()
                    self.columnInternalVerticalLayout_3.setSpacing(7)
                    self.columnInternalVerticalLayout_3.setObjectName("columnInternalVerticalLayout_3")
                    self.tagHeaderLayout_3 = QtWidgets.QHBoxLayout()
                    self.tagHeaderLayout_3.setSizeConstraint(QtWidgets.QLayout.SetMinimumSize)
                    self.tagHeaderLayout_3.setObjectName("tagHeaderLayout_3")
                    self.columnLabel_3 = QtWidgets.QLabel(self.combo_display_3)
                    self.columnLabel_3.setObjectName("columnLabel_3")
                    self.tagHeaderLayout_3.addWidget(self.columnLabel_3)
                    spacerItem4 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
                    self.tagHeaderLayout_3.addItem(spacerItem4)
                    self.columnInternalHorizontalLayout_3 = QtWidgets.QHBoxLayout()
                    self.columnInternalHorizontalLayout_3.setObjectName("columnInternalHorizontalLayout_3")
                    self.columnRejectBtn_3 = QtWidgets.QPushButton(self.columnWidget_3)
                    self.columnRejectBtn_3.setMaximumSize(QtCore.QSize(30, 30))
                    self.columnRejectBtn_3.setIcon(icons['images/trash_icon.png'])
                    self.columnRejectBtn_3.setObjectName("columnRejectBtn_3")
                    self.columnRejectBtn_3.clicked.connect(lambda:self.trash_item(3))
                    self.columnInternalHorizontalLayout_3.addWidget(self.columnRejectBtn_3)
                    self.tagHeaderLayout_3.addLayout(self.columnInternalHorizontalLayout_3)
                    self.columnInternalVerticalLayout_3.addLayout(self.tagHeaderLayout_3)
                    self.columnTextEdit_3 = QtWidgets.QTextEdit(self.columnWidget_3)
                    self.columnTextEdit_3.setStyleSheet("border: 1px solid grey; border-radius: 5px; background-color: palette(base);")
                    self.columnTextEdit_3.setTextInteractionFlags(QtCore.Qt.LinksAccessibleByMouse|QtCore.Qt.TextSelectableByKeyboard|QtCore.Qt.TextSelectableByMouse)
                    self.columnTextEdit_3.setObjectName("columnTextEdit_3")
                    self.columnInternalVerticalLayout_3.addWidget(self.columnTextEdit_3)
                    self.columnWidgetVerticalLayout_3.addLayout(self.columnInternalVerticalLayout_3)
                    self.mainVerticalLayout.addWidget(self.columnWidget_3)
                    self.columnWidget_3.raise_()
        
        
        
        self.bottomHr = QtWidgets.QFrame(self)
        self.bottomHr.setFrameShape(QtWidgets.QFrame.HLine)
        self.bottomHr.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.bottomHr.setObjectName("bottomHr")
        self.mainVerticalLayout.addWidget(self.bottomHr)
        
        self.bottomActionBarLayout = QtWidgets.QHBoxLayout()
        self.bottomActionBarLayout.setSizeConstraint(QtWidgets.QLayout.SetDefaultConstraint)
        self.bottomActionBarLayout.setObjectName("bottomActionBarLayout")
        self.additionalButtonsLayout = QtWidgets.QHBoxLayout()
        self.additionalButtonsLayout.setObjectName("additionalButtonsLayout")
        self.logButton = QtWidgets.QPushButton(self)
        self.logButton.setMaximumSize(QtCore.QSize(70, 16777215))
        self.logButton.setIcon(icons['images/system_log_icon.png'])
        self.logButton.setObjectName("logButton")
        self.additionalButtonsLayout.addWidget(self.logButton)
        self.bottomActionBarLayout.addLayout(self.additionalButtonsLayout)
        spacerItem5 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.bottomActionBarLayout.addItem(spacerItem5)
        
        self.acceptRejectAllWidget = QtWidgets.QWidget(self)
        self.acceptRejectAllWidget.setObjectName("acceptRejectAllWidget")
        self.acceptRejectAllLayout = QtWidgets.QHBoxLayout(self.acceptRejectAllWidget)
        self.acceptRejectAllLayout.setObjectName("acceptRejectAllLayout")
        self.rejectAllCheckbox = QtWidgets.QCheckBox(self)
        self.rejectAllCheckbox.setText("")
        self.rejectAllCheckbox.setObjectName("rejectAllCheckbox")
        self.acceptRejectAllLayout.addWidget(self.rejectAllCheckbox)
        self.rejectAllButton = QtWidgets.QPushButton(self)
        self.rejectAllButton.setIcon(icons['images/decline_icon.png'])
        self.rejectAllButton.setObjectName("rejectAllButton")
        self.acceptRejectAllLayout.addWidget(self.rejectAllButton)
        spacerItem6 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.acceptRejectAllLayout.addItem(spacerItem6)
        self.acceptAllCheckbox = QtWidgets.QCheckBox(self)
        self.acceptAllCheckbox.setText("")
        self.acceptAllCheckbox.setObjectName("acceptAllCheckbox")
        self.acceptRejectAllLayout.addWidget(self.acceptAllCheckbox)
        self.acceptAllButton = QtWidgets.QPushButton(self)
        self.acceptAllButton.setIcon(icons['images/accept_icon.png'])
        self.acceptAllButton.setObjectName("acceptAllButton")
        self.acceptRejectAllLayout.addWidget(self.acceptAllButton)
        self.bottomActionBarLayout.addWidget(self.acceptRejectAllWidget)
        
        
        spacerItem7 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.bottomActionBarLayout.addItem(spacerItem7)
        
        self.navigateButtonsWidget = QtWidgets.QWidget(self)
        self.navigateButtonsWidget.setObjectName("navigateButtonsWidget")
        self.navigateButtonsLayout = QtWidgets.QHBoxLayout(self.navigateButtonsWidget)
        self.navigateButtonsLayout.setObjectName("navigateButtonsLayout")
        self.resultBackButton = QtWidgets.QPushButton(self)
        self.resultBackButton.setMinimumSize(QtCore.QSize(20, 0))
        self.resultBackButton.setMaximumSize(QtCore.QSize(30, 30))
        self.resultBackButton.setObjectName("resultBackButton")
        self.navigateButtonsLayout.addWidget(self.resultBackButton)
        self.resultForwardButton = QtWidgets.QPushButton(self)
        self.resultForwardButton.setMaximumSize(QtCore.QSize(30, 30))
        self.resultForwardButton.setObjectName("resultForwardButton")
        self.navigateButtonsLayout.addWidget(self.resultForwardButton)       
        self.bottomActionBarLayout.addWidget(self.navigateButtonsWidget)
        
        
        self.acceptCompleteLayout = QtWidgets.QHBoxLayout()
        self.acceptCompleteLayout.setObjectName("acceptCompleteLayout")
        self.acceptCompleteButton = QtWidgets.QPushButton(self)
        self.acceptCompleteButton.setIcon(icons['images/accept_icon.png'])
        self.acceptCompleteButton.setObjectName("acceptCompleteButton")
        self.acceptCompleteLayout.addWidget(self.acceptCompleteButton)
        self.bottomActionBarLayout.addLayout(self.acceptCompleteLayout)
        
        self.mainVerticalLayout.addLayout(self.bottomActionBarLayout)
        
        self.bottomHr.raise_()
        self.topHr.raise_()

        self.retranslateUi(self)
        QtCore.QMetaObject.connectSlotsByName(self)

        self.resultBackButton.clicked.connect(self.load_previous_record)
        self.resultForwardButton.clicked.connect(self.load_next_record)
        
        self.acceptAllCheckbox.clicked.connect(self.toggle_accept_all_button)
        self.rejectAllCheckbox.clicked.connect(self.toggle_reject_all_button)
        
        ## apply metadata
        self.acceptCompleteButton.clicked.connect(self.apply_changes)
        self.acceptAllButton.clicked.connect(self.apply_changes)
        
        self.logButton.clicked.connect(self.show_job_log_dialog)
        
        ########################################################################################
        ########################################################################################
        ########################################################################################
        ########################################################################################
        ########################################################################################
        
        self.load_first_record()
        
    def update_current_position(self):
        self.noCurrentText.setText( str(self.VIEWER_POSITION) )
        self.noOutOfText.setText( str(self.VIEWER_END_POSITION) )
    
    def trash_item(self, cid = None):
        if cid != None and cid > -1 and cid < 4:
            if cid == 0:
                self.AI_ANSWERS[self.VIEWER_POSITION]['answers'][self.combo_label_0] = None
                self.columnTextEdit_0.setText("")
            if cid == 1:
                self.AI_ANSWERS[self.VIEWER_POSITION]['answers'][self.combo_label_1] = None
                self.columnTextEdit_1.setText("")
            if cid == 2:
                self.AI_ANSWERS[self.VIEWER_POSITION]['answers'][self.combo_label_2] = None
                self.columnTextEdit_2.setText("")
            if cid == 3:
                self.AI_ANSWERS[self.VIEWER_POSITION]['answers'][self.combo_label_3] = None
                self.columnTextEdit_3.setText("")
        
        print(self.AI_ANSWERS)

    def setup_ui(self):
        self.VIEWER_POSITION = 1
        self.VIEWER_END_POSITION = len( self.AI_ANSWERS )
        self.update_current_position()
        
        if self.VIEWER_END_POSITION == 1:
            self.acceptRejectAllWidget.setHidden(True)
            self.navigateButtonsWidget.setHidden(True)
        else:
            self.acceptCompleteButton.setVisible(False)
            # set the accept all and reject all buttons as disabled
            self.acceptAllButton.setEnabled(False)
            self.rejectAllButton.setEnabled(False)
    
    def toggle_accept_all_button(self):
        if self.acceptAllCheckbox.isChecked():
            self.acceptAllButton.setEnabled(True)
        else:
            self.acceptAllButton.setEnabled(False)
        
    def toggle_reject_all_button(self):
        if self.rejectAllCheckbox.isChecked():
            self.rejectAllButton.setEnabled(True)
        else:
            self.rejectAllButton.setEnabled(False)
            
    def update_book_title(self):
        if len(self.AI_ANSWERS) >= self.VIEWER_POSITION:
            self.bookNameText.setText(self.AI_ANSWERS[self.VIEWER_POSITION]['title'])
    
    def display_answers(self):
        self.columnTextEdit_0.setText(self.AI_ANSWERS[self.VIEWER_POSITION]['answers'].get(self.combo_label_0, None))
        if self.column_list_count > 0:
            self.columnTextEdit_1.setText(self.AI_ANSWERS[self.VIEWER_POSITION]['answers'].get(self.combo_label_1, None))
            if self.column_list_count > 1:
                self.columnTextEdit_2.setText(self.AI_ANSWERS[self.VIEWER_POSITION]['answers'].get(self.combo_label_2, None))
                if self.column_list_count > 2:
                    self.columnTextEdit_3.setText(self.AI_ANSWERS[self.VIEWER_POSITION]['answers'].get(self.combo_label_3, None))
    
    def update_button_status(self):
        if self.VIEWER_POSITION == 1:
            self.resultBackButton.setEnabled(False)
        else:
            self.resultBackButton.setEnabled(True)
        if self.VIEWER_POSITION == self.VIEWER_END_POSITION:
            self.resultForwardButton.setVisible(False)
            self.acceptCompleteButton.setVisible(True)
            self.acceptAllButton.setVisible(False)
            self.acceptAllCheckbox.setVisible(False)
        else:
            self.resultForwardButton.setVisible(True)
            self.acceptCompleteButton.setVisible(False)
            self.acceptAllButton.setVisible(True)
            self.acceptAllCheckbox.setVisible(True)
    
    def load_first_record(self):
        self.setup_ui()
        self.update_book_title()
        self.display_answers()
    
    def load_next_record(self):
        if self.VIEWER_POSITION != self.VIEWER_END_POSITION:
            self.VIEWER_POSITION += 1
            self.update_current_position()
            self.update_book_title()
            self.display_answers()
            self.update_button_status()
    
    def load_previous_record(self):
        if self.VIEWER_POSITION != 1:
            self.VIEWER_POSITION -= 1
            self.update_current_position()
            self.update_book_title()
            self.display_answers()
            self.update_button_status()
    
    def apply_changes(self):        
        
        payload = None
        id_map = {}
        custom_columns_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        valid_datatypes = ['text', 'comments', 'int', 'float', 'datetime', 'bool']
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        for count in self.AI_ANSWERS:
            
            book_id = self.AI_ANSWERS[count]['bid']
            mi = Metadata(_('Unknown'))
            
            for akey, avalue in self.AI_ANSWERS[count].get('answers',{}).items():            
                if avalue != None and avalue != "":
                    mi_field = '#'+akey
                    custcol = custom_columns_dict[mi_field]
                    custcol['#value#'] = avalue
                    mi.set_user_metadata(mi_field, custcol)
                    id_map[book_id] = mi
        
        ## process        
        QApplication.instance().processEvents()
        try:
            if len(id_map) > 0:
                edit_metadata_action.apply_metadata_changes(id_map, callback=None, merge_tags=True, merge_comments=False)
        except Exception as e:
            print("ERROR in:  edit_metadata_action.apply_metadata_changes:  ",str(e))
        QApplication.instance().processEvents()
        self.AI_ANSWERS = None
        
        self.parentdlg.close()
        self.close()
    
    '''
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_custom_metadata_using_standard_calibre(self,book_ids_list,results_list):

        payload = None
        custom_columns_dict = self.maingui.current_db.field_metadata.custom_field_metadata()
        valid_datatypes = ['text', 'comments', 'int', 'float', 'datetime', 'bool']
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        merge_tags = prefs['EPOM_MERGE_TAGS']
        results_list.sort()

        final_book_ids_list = []  #all books that had usable results...

        book_ids_list = list(set(book_ids_list))  #some books may have had no usable results...'continue' books...

        id_map = None
        mi = None
        prior_book = None

        for row in results_list:

            current_book,custom_column,final_text,source = row
            current_book = int(current_book)

            if  prior_book == None:
                prior_book = current_book
                mi = Metadata(_('Unknown'))
                id_map = {}
                is_finished = False
            elif current_book != prior_book:
                id_map[prior_book] = mi
                final_book_ids_list.append(prior_book)
                is_finished = True
                prior_book = current_book
                mi = Metadata(_('Unknown'))

            if not final_text > " ":
                continue

            if not custom_column in custom_columns_dict:
                continue

            cc_dict = custom_columns_dict[custom_column]
            datatype = cc_dict['datatype']
            if not datatype in valid_datatypes:
                continue

            if DEBUG: print(custom_column)

            if datatype == "comments":
                new_value = final_text
            elif datatype == "text":
                multiple_dict = cc_dict["is_multiple"]
                if "list_to_ui" in multiple_dict:
                    new_value_list = []  # tag-like in tag-browser
                    new_value = final_text  + ','
                    s = new_value.split(',')
                    if len(s) > 0:
                        for new_value in s:
                            if new_value is not None:
                                new_value = new_value.strip()
                                if new_value > " ":
                                    new_value_list.append(new_value)
                            #END FOR
                    new_value = new_value_list
                else: # single text shown in tag-browser
                    new_value = final_text
            elif datatype == "int":
                new_value = self.format_numerics(final_text,"int")
                if new_value is None:
                    continue
            elif datatype == "float":
                new_value = self.format_numerics(final_text,"float")
                if new_value is None:
                    continue
            elif datatype == "bool":
                ft = self.format_numerics(final_text,"int")
                if ft is not None:
                    new_value = str(ft)
                    if new_value == "1":
                        new_value = True
                    elif new_value == "0":
                        new_value = False
                    else:
                        continue
                else:
                    if new_value.lower() == "true" or new_value.lower() == "t" or new_value.lower() == "yes":
                        new_value = True
                    elif new_value.lower() == "false" or new_value.lower() == "f" or new_value.lower() == "no":
                        new_value = False
                    else:
                        continue
            elif datatype == "datetime":
                new_value = self.format_datetime(final_text)
            else:
                continue

            mi_field = custom_column
            custcol = custom_columns_dict[mi_field]   #   '#translator'
            custcol['#value#'] = new_value
            mi.set_user_metadata(mi_field, custcol)
            is_finished = False

        #END FOR

        if not is_finished:
            id_map[current_book] = mi
            final_book_ids_list.append(current_book)

        final_book_ids_list = list(set(final_book_ids_list))
        final_book_ids_list.sort()

        payload = final_book_ids_list

        QApplication.instance().processEvents()

        try:
            if len(id_map) > 0:
                edit_metadata_action.apply_metadata_changes(id_map, callback=None, merge_tags=merge_tags, merge_comments=False)
        except Exception as e:
            if DEBUG: print("ERROR in:  edit_metadata_action.apply_metadata_changes:  ",str(e))

        QApplication.instance().processEvents()

        del custom_columns_dict
        del results_list
        del id_map
        del mi

        final_book_ids_list = list(set(final_book_ids_list))

        if len(final_book_ids_list) > 0:
            self.mark_selected_books(final_book_ids_list)
            QApplication.instance().processEvents()

        if DEBUG:
            if len(book_ids_list) != len(final_book_ids_list):
                print("Original Books List differs from Final Books List due to lack of sufficient returned results to process the edit_metadata_action")
                print("Info:  len(book_ids_list): ", str(len(book_ids_list)), "    len(final_book_ids_list)", str(len(final_book_ids_list))) #  Caution:   len(book_ids_list):  5     len(final_book_ids_list) 4
    #---------------------------------------------------------------------------------------------------------------------------------------
    '''
        
    def retranslateUi(self, Dialog):
        _translate = QtCore.QCoreApplication.translate
        Dialog.setWindowTitle(_translate("Dialog", "Review AI Responses"))
        
        
        #self.logLabel.setText(_translate("Dialog", "Log:"))        
        #self.ppProgressBar.setFormat(_translate("Dialog", "%p%"))        
        #self.answer_1.setText(_translate("Dialog", "Answer 1"))
        #self.answer_2.setText(_translate("Dialog", "Answer 2"))
        #self.answer_3.setText(_translate("Dialog", "Answer3"))
        #self.answer_4.setText(_translate("Dialog", "Answer4"))
        
        #self.resultDisplayText.setText(_translate("Dialog", "Result:"))
        #self.bookNameText.setText(_translate("Dialog", "<html><head/><body><p><span style=\" font-size:10pt;\">Book Name</span></p></body></html>"))
        #self.resultForwardPushButton.setText(_translate("Dialog", ">"))
        #self.resultBackPushButton.setText(_translate("Dialog", "<"))
        #self.noCompletedText.setText(_translate("Dialog", "20000"))
        #self.outOfLabel.setText(_translate("Dialog", "/"))
        #self.noOutOfText.setText(_translate("Dialog", "20000"))
        
        #self.setWindowTitle(_translate("self", "Dialog"))
        
        self.resultDisplayText.setText(_translate("Dialog", "Result:"))
        #self.bookNameText.setText(_translate("Dialog", "Book Name"))
        #self.noCurrentText.setText(_translate("Dialog", "20000"))
        self.outOfLabel.setText(_translate("Dialog", "/"))
        #self.noOutOfText.setText(_translate("Dialog", "20000"))
        
        self.logButton.setText(_translate("Dialog", "Log"))
        self.rejectAllButton.setText(_translate("Dialog", "Reject All"))
        self.acceptAllButton.setText(_translate("Dialog", "Accept All"))
        self.acceptCompleteButton.setText(_translate("Dialog", "Accept"))
        self.resultBackButton.setText(_translate("Dialog", "<"))
        self.resultForwardButton.setText(_translate("Dialog", ">"))
        

'''
if __name__ == "__main__":
    import sys
    app = QtWidgets.QApplication(sys.argv)
    Dialog = QtWidgets.QDialog()
    ui = Ui_Dialog()
    ui.setupUi(Dialog)
    Dialog.show()
    sys.exit(app.exec_())
'''