try:
    from qt.core import Qt, QDialog, QLabel, QMessageBox, QPushButton, QVBoxLayout, QProgressBar, QWidget, QComboBox, QHBoxLayout, QPlainTextEdit, QSize, QSizePolicy, QApplication
except ImportError:
    from PyQt5.Qt import Qt, QDialog, QLabel, QMessageBox, QPushButton, QVBoxLayout, QProgressBar, QWidget, QComboBox, QHBoxLayout, QPlainTextEdit, QSize, QSizePolicy, QApplication

from PyQt5 import QtCore, QtGui, QtWidgets

from calibre.ebooks.metadata.book.base import Metadata
import calibre_plugins.ai_custom_tag_extractor.assets.about_labels

class AboutDialog(QDialog):
    
    def __init__(self, gui, icon, *args):        
        QDialog.__init__(self, gui)
        self.gui = gui
        
        self.setObjectName("Dialog")
        self.setWindowIcon(icon)
        self.setWindowModality(QtCore.Qt.NonModal)
        self.resize(800, 648)
        self.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
        self.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.setStyleSheet('QDialog#Dialog{background-image:url(:/images/background_small_faded.png); background-repeat: no-repeat; background-position: bottom left;}')
        self.setSizeGripEnabled(True)
        self.setModal(False)
        
        self.verticalLayout = QtWidgets.QVBoxLayout(self)
        self.verticalLayout.setObjectName("verticalLayout")
        self.verticalLayout_2 = QtWidgets.QVBoxLayout()
        self.verticalLayout_2.setObjectName("verticalLayout_2")
        self.horizontalLayout_2 = QtWidgets.QHBoxLayout()
        self.horizontalLayout_2.setContentsMargins(-1, -1, -1, 0)
        self.horizontalLayout_2.setObjectName("horizontalLayout_2")
        spacerItem = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.horizontalLayout_2.addItem(spacerItem)
        self.label_3 = QtWidgets.QLabel(self)
        self.label_3.setText("")
        self.label_3.setPixmap(QtGui.QPixmap(":/images/digital_assassins_logo.png"))
        self.label_3.setScaledContents(False)
        self.label_3.setWordWrap(False)
        self.label_3.setOpenExternalLinks(True)
        self.label_3.setObjectName("label_3")
        self.horizontalLayout_2.addWidget(self.label_3)
        self.verticalLayout_2.addLayout(self.horizontalLayout_2)
        spacerItem1 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem1)
        self.label_2 = QtWidgets.QLabel(self)
        self.label_2.setStyleSheet("font-size:14px;")
        self.label_2.setWordWrap(True)
        self.label_2.setObjectName("label_2")
        self.verticalLayout_2.addWidget(self.label_2)
        spacerItem2 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem2)
        self.label = QtWidgets.QLabel(self)
        self.label.setStyleSheet("font-weight:bold;")
        self.label.setObjectName("label")
        self.verticalLayout_2.addWidget(self.label)
        self.plainTextEdit = QtWidgets.QPlainTextEdit(self)
        self.plainTextEdit.setObjectName("plainTextEdit")
        self.verticalLayout_2.addWidget(self.plainTextEdit)
        spacerItem3 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem3)
        self.label_4 = QtWidgets.QLabel(self)
        self.label_4.setStyleSheet("font-style:italic; color:red;")
        self.label_4.setScaledContents(False)
        self.label_4.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_4.setWordWrap(True)
        self.label_4.setObjectName("label_4")
        self.verticalLayout_2.addWidget(self.label_4)
        self.verticalLayout.addLayout(self.verticalLayout_2)
        self.horizontalLayout = QtWidgets.QHBoxLayout()
        self.horizontalLayout.setObjectName("horizontalLayout")
        spacerItem4 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem4)
        self.buyusacoffee = QtWidgets.QPushButton(self)
        self.buyusacoffee.setMinimumSize(QtCore.QSize(120, 0))
        self.buyusacoffee.setMaximumSize(QtCore.QSize(120, 16777215))
        self.buyusacoffee.setAutoFillBackground(False)
        self.buyusacoffee.setStyleSheet("background:FF922A;")
        self.buyusacoffee.setText("")
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(":/images/buy_us_a_coffee.png"))
        self.buyusacoffee.setIcon(icon)
        self.buyusacoffee.setIconSize(QtCore.QSize(150, 30))
        self.buyusacoffee.setDefault(False)
        self.buyusacoffee.setFlat(True)
        self.buyusacoffee.setObjectName("buyusacoffee")
        self.horizontalLayout.addWidget(self.buyusacoffee)
        self.verticalLayout.addLayout(self.horizontalLayout)

        self.retranslateUi(self)
        QtCore.QMetaObject.connectSlotsByName(self)
        
        self.buyusacoffee.clicked.connect(self.buy_us_a_coffee)
    
    def buy_us_a_coffee(self):
        import webbrowser
        url = "https://www.paypal.com/donate/?hosted_button_id=LHVA9QXLU7TG6"
        webbrowser.open(url, new=0, autoraise=True)
    
    def visit_digital_assassins(self):
        import webbrowser
        url = "https://www.digitalassassins.co.uk"
        webbrowser.open(url, new=0, autoraise=True)
    
    def retranslateUi(self, Dialog):
        _translate = QtCore.QCoreApplication.translate
        Dialog.setWindowTitle(_translate("Dialog", "Dialog"))
        self.label_2.setText(_translate("Dialog", "<html><head/><body><p><i>Developed by Digital Assassins</i></p><p>Requires calibre &gt;= 0.8.40</p><p>This plugin is free to use for both personal and commercial usage under the GNU General Public License version 3 (GPLv3). </p><p>You may modify the original source code.</p></body></html>"))
        self.label.setText(_translate("Dialog", "Software Disclaimer:"))
        self.plainTextEdit.setPlainText(_translate("Dialog", "The developer of this plugin is in no way affiliated with Calibre, Mintplex Labs (AnythingLLM), Nomic (GPT4All) or OpenWebUI. \n"
"All images, logos and content displayed in this plugin are protected by copyright law and copyright remains with their respective owners.\n"
"\n"
"This plugin is provided \"as is\" without warranty of any kind, either express or implied, including, but not limited to, the implied warranties of merchantability, fitness for a particular purpose, and non-infringement.\n"
"\n"
"Digital Assassins does not warrant that:\n"
"- the plugin will meet your requirements;\n"
"- the plugin will be uninterrupted, timely, secure, or error-free;\n"
"- the results that may be obtained from the use of the plugin will be accurate or reliable;\n"
"- the quality of the plugin will meet your expectations;\n"
"- any errors in the plugin will be corrected.\n"
"\n"
"Digital Assassins shall not be liable for any direct, indirect, incidental, special, consequential, or punitive damages arising out of the use of this plugin,even if advised of the possibility of such damages. \n"
"This includes but is not limited to damages for loss of profits, data, use, goodwill, or other intangible losses.\n"
"By using this plugin, you acknowledge that you have read this disclaimer and that you understand its terms."))
        self.label_4.setText(_translate("Dialog", "We built this plugin in our spare time. If you find this Plugin helpful, please consider buying us a coffee."))