# Ultimate AI Custom Tag Extractor Plugin

## Overview

This plugin offers a way to retrieve your own metadata from your book collection automatically using the power of AI

Currently only supports Anything LLM on the initial release but GPT4All and OpenWebUI integration is on the way.

What is this plugin useful for? You can Extract information from a book that would require intelligence, that simply can't be aquired using standard RegEx.

For instance, how can a RegEx match the main character, or who the Bad guy is in a story ? unless the book actually states BadGuy: its impossible..

You also need to be proficient in RegEx, something that can bamboozle the average user. 

With this plugin, you simply use Natural language to extract what you need.

I've found these plugins extremely useful for organising a collection of millions of books. Something that would have taken years by hand..

Firstly, I used the "AI Metadata Plugin" available to download here:

I then found all the basic metadata that simply isnt available for the majority of rare / out of print / self published books 
where metadata just simply isnt available on the internet.

I then used the "AI Tag Extractor" plugin to read back through the content and provide a file structure to save the book into.

Just to break down what i did:

I first created a Custom column called "filestructure" by going to "Preferences > Add your own Columns > +Add Custom Column"

Then I set the column as Hierachial by going to "Preferences > Look & Feel > Hierachy & Searching Tab" Then ticked the box next to "#filestructure"

Next thing was to set the Save format for file output, to save each book into the correct folder structure.

I went to: "Preferences > Saving books to disk > Template Editor"

In the Template box at the top I typed:

program:
    switch_if( ifempty($#filestructure,''), strcat(list_join('/', $#filestructure,'.'), '/', $title, format_date(ifempty($pubdate, '' ),' (yyyy)')), strcat($title, format_date(ifempty($pubdate, '' ),' (yyyy)') ) )

We are now set up and ready to go.. First, I selected the books i wanted to Organise, since i wanted all of them organising I used the keyboard shortcut "CTRL+A"

Clicked on the "AI Extractor" in the top menu to open the plugin.

In the column I chose "filestructure" and in the AI Prompt box i typed:

"Based on the content of the book, recommend a folder structure to save this book into. For example, a book on Python Programming might go in a folder structure like 'Computing.Programming.Python'. You may use underscores in folder names. Use a period as a path seperator. If the book is Fiction, include the sub category and Author in the path."

Then simply clicked "Extract Tags"

The AI read through the books one by one and suggested a category for each book and saved this into the filestructure column in my calibre Metadata.

I hit a snag, I had organised all my ADHD books into a folder "Mental Health/ADHD" how come the AI has put them in two seperate folders?

It has put some books in "SelfHelp/ADHD" and some in "Medical/ADHD" why ?

On closer inspection, i realised that the AI is understanding not only the context of the content but also the target audience.

The books in the "Medical" folder are aimed at medical professionals like Psychologists, the "Self Help" books are aimed at Parents / Individuals with ADHD.

I realised it is doing a better job than i could just guessing the context from the book titles.

Once it had finished, I then embedded the metadata in the eBook files using Calibres built in "Embed Metadata" function, then clicked "Save to disk"

This then saved the books into the folder structure the AI had suggested.

I just sorted my full library, all the missing metadata and folder organisation with a few clicks.

Ive also created two helper plugins that bypass the multi click restrictions of Calibre itself, those are available here:

These plugins allow you to download with the built in metadata plugins with one click from the toolbar, then one click get metadata using AI.

Speeding up the process when working through your collection. 

No more clicking on the fiddly down arrow next to "Edit Metadata" then clicking "Download Metadata", then clicking "Metadata Only" just to download metadata

If you wanted to switch between the inbuilt metadata plugins and the AI plugin, you would have to click "configure" in the options and tick/untick one by one.

The download AI metadata button plugin makes this process a breeze, it toggles the built in metadata off temporarily, downloads the metadata with the AI plugin, 
then switches the built-in Metadata Plugins back on again. Speeding up working with both built in and AI metadata plugins at the same time.

Hope you found these plugins as useful as I have.. 

We have built these plugins in our spare time. These are totally free to use.. if you have found them useful, please consider buying us a coffee:
https://www.paypal.com/donate/?hosted_button_id=LHVA9QXLU7TG6

## Development / Contributions

Special Thanks to kiwidude's calibre plugin debug script for making life a little easier :)